/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.java.dev.designgridlayout.AbstractRow;

final class RowIterator
implements Iterator<AbstractRow> {
    private final List<AbstractRow> _rows;
    private int _index = 0;

    public static Iterable<AbstractRow> each(final List<AbstractRow> rows) {
        return new Iterable<AbstractRow>(){

            @Override
            public Iterator<AbstractRow> iterator() {
                return new RowIterator(rows);
            }
        };
    }

    private RowIterator(List<AbstractRow> rows) {
        this._rows = rows;
    }

    @Override
    public AbstractRow next() {
        int index2 = this.findNext();
        if (index2 != -1) {
            this._index = index2 + 1;
            return this._rows.get(index2);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.findNext() != -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int findNext() {
        for (int i = this._index; i < this._rows.size(); ++i) {
            AbstractRow row = this._rows.get(i);
            if (row.isEmpty()) continue;
            return i;
        }
        return -1;
    }
}

